% Harmonic_Drive_FHA_C_mini_Gear 
[D
	/Caption 'Harmonic_Drive_FHA_C_mini'
	/Type 'Actuator Definition File'
	/Version 30
	/MinMCSubVersionR6 0		% This File requires MS SW Parameter Tree Version 6.0 or higher  (for release 6 firmware) 	
 %************************************************************************************************* 
	/WizardPages [A
		[D	
			/PageID		9			%Actuator Selection for rotative motors
			/PageInfo	[A  	  	
  			[D /Name 'Motor_Name' /CapitalLetters #1]	 
		  	[D /Name 'Maximal_Current' /Tabs 1 ]
				[D /Name 'NoOfPolePairs' /Tabs 1 ]
				[D /Name 'BEMFConstant' /Tabs 1 ] 
				[D /Name 'PhasePhase_Resistance' /Tabs 1 ]
		  	[D /Name 'PhasePhase_Inductance'/Tabs 1 ]	
			]
		]
		[D	
			/PageID		19			%Controller Settings
			/PageInfo	[A  	  	
			]
		]		
		[D	
			/PageID		2			%Extension Cable Setup
			/PageInfo	[A  	  	
				[D /Name 'Coil_Resistance' ]	
				[D /Name 'Ext_Cable_Resistance'   ]
				[D /Name 'Total_Resistance' ]
			]

		]
		[D							%UnitSystem 
			/PageID 25 
			/PageInfo [A 
			] 
		] 		
		[D	
			/PageID		11			%Position Feedback Type A
			/PageInfo	[A  	  	
				[D /Name 'Com_PeriodLength' ]
%				[D /Name 'Com_PhaseAngle' ]
%				[D /Name 'PhaseSearch_MaxPos' ]
%				[D /Name 'PhaseSearch_MaxSpeed' ]			
%				[D /Name 'Force_Constant' ]
				[D /Name 'LinBEMFConstant' ]
			]
  	]
	[D
		/PageID		29
		/PageInfo	[A
		]
	]
		[D	
			/PageID		6				%Homing I 
			/PageInfo	[A  	  	
  		]	
  	]
		[D	
			/PageID		13			%Homing II (for rotative Motors)
			/PageInfo	[A  	  	
  		]	
  	]
		[D	
			/PageID		24			%Thermical model parameters
			/PageVL 	1
			/PageInfo	[A  	  	
			]
		]		
		[D	
			/PageID		26			%Extended UPID 
			/PageVL 	1
			/PageInfo	[A  	  	
			]
		]		
	]

 %************************************************************************************************* 
  	
   /WizardValues [A      
		[D
			/Name 'Actuator_Type'
			/Caption 'Actuator Type'
			/Type 'INTEGER'
			/Value 6
		]	   			
 		[D
			/Name 'Motor_Name'
			/CaptionKeyWord 'Motor'
			/Type 'STRING'
			/Value '' 
		]  
		[D
			/Name 'BEMFConstant'
			/Caption 'BEMF Constant'
			/Type 'Double'
			/Value 0.0
			/UUID $2A
		]  	  
		[D 
			/Name 'PhasePhase_Resistance'
			/CaptionKeyWord 'PhasePhase_Resistance'
			/Type 'Double'
			/Value 0.0
			/UUID	$F
		]
		[D 
			/Name 'PhasePhase_Inductance'
			/CaptionKeyWord 'PhasePhase_Inductance'
			/Type 'Double'
			/Value 0.0
			/UUID	$10
		]
		[D
			/Name 'LinBEMFConstant'
			/Caption 'BEMF Constant'
			/Type 'Double'
			/Value 0.0
			/UUID $19
		]  
	  
 

% EXTENSION CABLE
   	[D
   		/Name 'Total_Resistance'
   		/CaptionKeyWord 'Total_Resistance'
   		/Type 'Double'
   		/Value 0.0
   		/UUID 15
   	]	   		   	      
      [D
   		/Name 'Cable1_Resistivity'
   		/Caption 'Cable1 Resistivity'
   		/Type 'DOUBLE'
   		/Value 0.0 
   		/UUID 39
   	]	   		   	
      [D
   		/Name 'Cable2_Resistivity'
   		/Caption 'Cable2 Resistivity'
   		/Type 'DOUBLE'
   		/Value 0.0 
   		/UUID 39   		
   	]	   		   	
      [D
   		/Name 'Cable1_Resistivity_Gen'
   		/Caption 'Cable1 Resistivity Generic'
   		/Type 'DOUBLE'
   		/Value 0.0 
   		/UUID 39
   	]	   		   	
      [D
   		/Name 'Cable2_Resistivity_Gen'
   		/Caption 'Cable2 Resistivity Generic'
   		/Type 'DOUBLE'
   		/Value 0.0 
   		/UUID 39   		
   	]	
% PositionFB
	[D
		/Name 'ExtSensor_Resolution2'
   		/Type 'DOUBLE'
   		/Value 0.0 
   		/UUID 5  
		/OnChange [A 
			[D /Name 'SetExtSensor_Resolution2' ]				
		]  		
   	]	   		   	
% Homing
   ]
   
%************************************************************************************************* 
    
	/MCParameters [A
		[D
			/Name 'DriveName'
			/TreeUPID 1000 
			/Type 'STRING'
			/StartWithTreeValue #1
		]   		
		[D
			/Name 'Motor_Supply_Voltage_Low_Warn'
			/TreeUPID 4120
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]
		[D
			/Name 'Motor_Supply_Voltage_Low_Error'
			/TreeUPID 4122
			/Type 'DOUBLE'
			/StartWithTreeValue #1
		]
		[D              	   	   
			/Name 'PlugAndPlay'   	
			/TreeUPID 112
			/StartWithTreeValue #1
			/Type 'ENUM'
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
		]
		[D
			/Name 'StatorInfoBlock_ArtNr'
			/TreeUPID 6276
			/DefValue 1			
			/Type 'ENUM'
		]
		[D              	   	   

			/Name 'MCTreeID'
			/TreeUPID 1377
			/Type 'ENUM'
			/ReadOnlyPar #1
			/OnChange [A ]
			/ENumDef [A ]																		   		 	   	

		]
   	[D
   		/Name 'Phase_Switch_On_Test_Low_Level'
   		/TreeUPID 4140
   		/Type 'DOUBLE'
   	]
   	[D
   		/Name 'Phase_Switch_On_Test_High_Level'
   		/TreeUPID 4141
   		/Type 'DOUBLE'
   	]
   	[D
   		/Name 'Phase_Switch_On_Test_Max_InCurrent'
   		/TreeUPID 4142
   		/Type 'DOUBLE'
   	]
   	[D              	   	   
   		/Name 'Motor_Type'   	
   		/TreeUPID 4500
   		/Type 'ENUM'
   		/DefValue 1
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'No Motor'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					%/Caption 'Generic'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					%/Caption 'P01'					
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
   	]
		[D              	   	   
			/Name 'Motor_Type_Sel'   	
			/TreeUPID 4501
			/Type 'ENUM'
			/DefValue 2
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Undefined'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					%/Caption 'Linear'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					%/Caption 'Rotative'					
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
		]
	[D
		/Name 'ADF_Name'
		/TreeUPID 6220 
		/Type 'STRING'
		/DefValue 'Harmonic_Drive_FHA_C_mini_Gear' 	   		   		   	   	
	]   	
	[D
		/Name 'MDF_Name'
		/TreeUPID 6255 
		/Type 'STRING'
	]   	
   	[D
   		/Name 'Stator_Type_Code'
   		/TreeUPID 4613 
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	   	
   	]   	
   	[D
   		/Name 'Coil_Resistance'
   		/CaptionKeyWord 'Phase_Resistance'
   		/TreeUPID 4511 
   		/Type 'DOUBLE'
   	]
   	[D
   		/Name 'Coil_Resistance_Definition_Temp'
   		/TreeUPID 4619 
   		/Type 'DOUBLE'
   		/DefValue 25.0
   		
   	]   	   	
	[D
		/Name 'NoOfPolePairs'
		/CaptionKeyWord 'NoOfPolePairs'
		/TreeUPID 6245 
		/Type 'DOUBLE'
		/DefValue 1.0
	]  
   	[D
   		/Name 'Coil_Inductivity'
   		/TreeUPID 4512 
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Force_Constant'
   		/CaptionKeyWord 'Force_Constant'   		
   		/TreeUPID 4513 
   		/Type 'DOUBLE'
   		/DefValue 0.0
   	]
   	[D
   		/Name 'EdgeForce_Constant'
   		/CaptionKeyWord 'EdgeForce_Constant'
   		/TreeUPID 4517 
   		/Type 'DOUBLE'
   		/DefValue 0.0
   	]
   	[D
   		/Name 'Zero_Position'
   		/CaptionKeyWord 'Zero_Position'
   		/TreeUPID 4514 
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	   	   		
   	]	   		   	
   	[D
   		/Name 'Shortened_Stroke'
   		/CaptionKeyWord 'Shortened_Stroke'  		
   		/TreeUPID 4515 
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	   	   		   		
   	]
   	[D
   		/Name 'Maximal_Stroke'
   		/CaptionKeyWord 'Maximal_Stroke'
   		/TreeUPID 4516 
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	   	   		   		   		
   	]	   		   	
   	[D
   		/Name 'Maximal_Current'
   		/CaptionKeyWord 'Maximal_Current'
   		/TreeUPID 4510 
   		/Type 'DOUBLE'
   		/OnChange [A
				[D /Name 'CalculateControlParameters' ]
		]	
   	]	   		   	
   	
	[D
		/Name 'Maximal_Motor_Supply_Voltage'
		/TreeUPID 4519
		/Type 'DOUBLE'
	]	   		   	

% FEEDBACK SELECTION BEGIN
	[D
   		/Name 'Feedback_Selection'
			/TreeUPID 5010
			/Type 'ENUM'
 			/DefValue 1 	   
 			/OnChange [A ]  
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Feedback on X3 Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Feedback on X12 Sensor'					
					/OnSelect [A ]
				]																											
			]	
		]      	   		   		   	  	      	   	
   	[D
   		/Name 'Double_Feedback_Check'
   		/TreeUPID 4711 
   		/Type 'ENum'
   		/DefValue 0
   		/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A ]
				]																											
   		] 	   		   		   	
   	]	   		   	
		[D
   		/Name  'Maximal_Feedback_Difference'
			/TreeUPID 4710
			/Type 'DOUBLE'
		]
% FEEDBACK SELECTION END   	

% MOTOR SENSOR CONFIGURATION BEGIN
   	[D
   		/Name 'MotSen_Type'
   		/TreeUPID 4570
   		/Type 'ENum'
   		/DefValue 0
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'No Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Incremental AB encoder'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Sine/Cosine sensor'					
					/OnSelect [A 
						[D /Name 'PosRec_PositionTolerance' /Value 0.01 ]
					]
				]																											
				[D
					/Value 3
					%/Caption 'Absolut sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 4
					%/Caption 'Analog Absolut 0..5V'					
					/OnSelect [A ]
				]																											   		
   		] 	   		   		   	
   	]	   		   	   	
   	[D
   		/Name 'MotSen_Count_Direction'
   		/TreeUPID 4571
   		/Type 'ENum'
   		/DefValue 0
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Positive'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Negative'					
					/OnSelect [A ]
				]																											
   		] 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_WaveForm_Table'
   		/TreeUPID 4520 
   		/Type 'ENum'
   		/DefValue 0
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		
   		] 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_FFT_C1'
   		/TreeUPID 4521
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_FFT_C3'
   		/TreeUPID 4522 
   		/Type 'DOUBLE'
   		/DefValue 0.0	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_FFT_C5'
   		/TreeUPID 4523 
   		/Type 'DOUBLE'
   		/DefValue 0.0	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_FFT_C7'
   		/TreeUPID 4524 
   		/Type 'DOUBLE'
   		/DefValue 0.0	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_FFT_C9'
   		/TreeUPID 4525 
   		/Type 'DOUBLE'
   		/DefValue 0.0 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'ArcTan_Table'
   		/TreeUPID 4529
   		/Type 'ENum'
   		/DefValue 0
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2048
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   		
   		] 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'MotSen_Resolution'
   		/TreeUPID 4572
   		/Type 'DOUBLE'
   		/DefValue 0.01 	   		   		   	
   	]	   		   	
	[D
		/Name 'PosRec_PositionTolerance'
		/StartWithTreeValue #1
		/TreeUPID 5089
		/Type 'DOUBLE'
	]	   		   		
   	[D
   		/Name 'MotSen_SignalOffsetSine'
   		/TreeUPID 4573
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'MotSen_SignalOffsetCosine'
   		/TreeUPID 4574
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'MotSen_Relative_Cos_Gain'
   		/TreeUPID 4579
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'MotSen_Hall_Distance_Err'
   		/TreeUPID 4575
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'MotSen_SpeedFilterTime'
   		/TreeUPID 4578
   		/Type 'DOUBLE'
   	]	   		   	
      % CROSS COUPLING
   	[D
   		/Name 'CrossCoupling_PH1_Sine'
   		/TreeUPID 4580
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'CrossCoupling_PH1_Cosine'
   		/TreeUPID 4581
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'CrossCoupling_PH2_Sine'
   		/TreeUPID 4582
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'CrossCoupling_PH2_Cosine'
   		/TreeUPID 4583
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'CrossCopling_SignalDelayTime'
   		/TreeUPID 4755
   		/Type 'DOUBLE'
   	]	   		   	
% MOTOR SENSOR CONFIGURATION END

% MOTOR HALL SIGNAL BEGIN
   	[D
   		/Name 'Slider_Missing_Level'
   		/TreeUPID 4640
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Hall_Signal_Missing_Level'
   		/TreeUPID 4641
   		/Type 'DOUBLE'
   	]	   		   	
% MOTOR HALL SIGNAL END


% EXTERNAL SENSOR CONFIGURATION BEGIN
		[D
   			/Name 'ExtSensor_Type'
			/TreeUPID 4700
			/Type 'ENUM'
   			/DefValue 4
   			/OnChange [A 
			]  
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Sensor'					
					/Hide #1					
					/OnSelect [A
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Incremental_AB'					
					/Hide #1
					/OnSelect [A	
					]
				]																											
				[D
					/Value 4
					/CaptionKeyWord 'Incremental_ABZ'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 2
					/CaptionKeyWord 'Analog_Sine_Cosine'					
					/Hide #1
					/OnSelect [A	
					]
				]																											
				[D
					/Value 3
					%/Caption 'Absolute Sensor'					
					/Hide #1
					/OnSelect [A	
					]
				]																											
			]	
		]      	   		   		   	  	   
		[D              	   	   
			/Name 'X13_Sensor_Type_Sel'   	
			/TreeUPID 4503
			/Type 'ENUM'
			/DefValue 2
			/OnChange [A  ]
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Undefined'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 1
					%/Caption 'Linear'					
					/OnSelect [A	]								
				]																											
				[D
					/Value 2
					%/Caption 'Rotative'					
					/OnSelect [A	]								
				]																											
			]																		   		 	   	
		]
		[D
   		/Name 'ExtSensor_Direction'
			/TreeUPID 4701
			/Type 'ENUM'
   			/DefValue 0
   			/StartWithTreeValue #1
			/OnChange [A 
%				[D /Name 'ChangeECMotorCountDirection' ]
			]  
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'Clockwise'					
					/OnSelect [A	
					  	[D /Name 'Invert_Hall_Switches' /Value 1]
				  		[D /Name 'Com_Ph1ToPh2Angle' /Value -2.0943951023931954923084289221863]  		
					   	[D /Name 'Com_PhaseAngle' 	/Value 3.141592654]		
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Counterclockwise'					
					/OnSelect [A	
					  	[D /Name 'Invert_Hall_Switches' /Value 0]
				  		[D /Name 'Com_Ph1ToPh2Angle' /Value 2.0943951023931954923084289221863]		
					   	[D /Name 'Com_PhaseAngle' 	/Value 3.141592654]	
					]
				]																											
			]	
		]      	   		   		
   	[D
   		/Name 'ExtSen_WaveForm_Table'
   		/TreeUPID 4720
   		/Type 'ENum'
   		/DefValue 1
   		/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
   		] 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'ExtSen_FFT_C1'
   		/TreeUPID 4721
   		/DefValue 1.0
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'ExtSen_FFT_C3'
   		/TreeUPID 4722
   		/DefValue 0.0 
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'ExtSen_FFT_C5'
   		/TreeUPID 4723
   		/DefValue 0.0    		
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'ExtSen_FFT_C7'
   		/TreeUPID 4724
   		/DefValue 0.0 
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'ExtSen_FFT_C9'
   		/TreeUPID 4725
   		/DefValue 0.0 
   		/Type 'DOUBLE'
   	]	   		   										
		[D
   		/Name 'ExtSensor_Resolution'
			/TreeUPID 4702
			/DefValue 0.00000125
   			/StartWithTreeValue #1
			/OnChange [A 
				[D	/Name 'CalculateMotorProperty']										
			]  
			/Type 'DOUBLE'
		]   
		[D   	   		   		   	  	   
   		/Name 'ExtSensor_CountsPerRev'
			/TreeUPID 4707
			/DefValue 8000.0
   			/StartWithTreeValue #1
			/OnChange [A 
				[D	/Name 'CalculateMotorProperty']													
			]  
			/Type 'DOUBLE'
		]      	   		   		   	  	   		
		[D
   		/Name 'ExtSensor_SpeedTime'
			/TreeUPID 4706
   			/StartWithTreeValue #1
			/OnChange [A ]  
			/Type 'DOUBLE'
		]      	   		   		   	  	            	   		   		   	  	      
% EXTERNAL SENSOR CONFIGURATION END

% COMMUTATION BEGIN
   	[D
   		/Name 'Com_NumberOfPhases'
   		/TreeUPID 4590
   		/Type 'ENum'
   		/DefValue 3  % Phases
   		/ENumDef [A  
				[D
					/Value 1
					%/Caption '1 Phase'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption '2 Phases'					
					/OnSelect [A ]
				]																											
				[D
					/Value 3
					%/Caption '3 Phases'					
					/OnSelect [A ]
				]																											   	   		
   		] 	   		   		   	
   	]
	[D
   		/Name 'Com_Ph1ToPh2Angle'
		/TreeUPID 4597
		/Type 'DOUBLE'
	]      	   		   		   	  	      		   		   	
   	[D
   		/Name 'Com_AngleInfoSource'
   		/TreeUPID 4591
   		/Type 'ENum'
 %  		/StartWithTreeValue #1
   		/DefValue 4  
   		/ENumDef [A
				[D
					/Value 1
					%/Caption 'SIN/COS on X3 Motor Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'SIN/COS on X12 External Sensor'					
					/OnSelect [A ]
				]																											
				[D
					/Value 3
					%/Caption 'Sensor Position On X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 7
					%/Caption 'AB Sensor Position on X12'					
					/OnSelect [A ]
				]																											   	   		   						
				[D
					/Value 4
					%/Caption 'ABZ Sensor Position on X12'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 5
					%/Caption 'Hall Switches on X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 6
					%/Caption 'Hall Switches on X10'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 0
					%/Caption 'External'					
					/OnSelect [A ]
				]																											   	   		   		
   		] 	   		   		   	
   	]	   		   	
   	[D
   		/Name 'Com_InitMode'
   		/TreeUPID 4592
   		/Type 'ENum'
   		/DefValue 6  % 
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'Alpha Shot on X3'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Alpha Shot on X12'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 5
					%/Caption 'Hall Switches on X3 Until First Z'					
					/OnSelect [A ]
				]																											   	   		   						
				[D
					/Value 6
					%/Caption 'Hall Switches on X10 Until First Z'					
					/OnSelect [A ]
				]	
				[D
					/Value 7
					%/Caption 'Phase Search First Switch On'					
					/OnSelect [A ]
				]	
				[D
					/Value 13
					%/Caption 'Hall Switches On X3 Until Hall Switch Edge'					
					/OnSelect [A ]
				]	
				[D
					/Value 14
					%/Caption 'Hall Switches On X10 Until Hall Switch Edge'					
					/OnSelect [A ]
				]																										   	   		   		
   		] 	   		   		   	
   	]	   		   	
		[D
   		/Name 'Com_PeriodLength'
			/TreeUPID 4593
			/CaptionKeyWord 'Commutation_Period'
   			/DefValue 0.0 
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
   		/Name 'Com_PhaseAngle'
			/TreeUPID 4594
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
   		/Name 'Com_DeathTimeCompensation'
			/TreeUPID 4595
			/Type 'DOUBLE'
			/DefValue 0.00032
		]      	   		   		   	  	   
		[D		
		/Name 'Invert_Hall_Switches'
			/TreeUPID 4598
			/Type 'ENUM'	
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Off'
					/OnSelect [A ]
				]
				[D
					/Value 1
					%/Caption 'On'
					/OnSelect [A ]
				]	
			]				
		]
		[D
			/Name 'Hall_Switches_Mode'
			/TreeUPID 4599
			/Type 'ENUM'	
			/DefValue 0
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Left Aligned'
					/OnSelect [A ]
				]
				[D
					/Value 1
					%/Caption 'Right Aligned'
					/OnSelect [A ]
				]	
			]				
		]		

		
		[D
   		/Name 'Com_BackEMFCalcSource'
		/TreeUPID 4596
		/Type 'ENUM'
   		/DefValue 2
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'Demand Velocity'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'Velocity of X3 Feedback'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Velocity of X12 Feedback'					
					/OnSelect [A ]
				]																											   	   		   		
   		] 	   		   		   	
		]      	   		   		   	  	   
		[D
   		/Name 'Com_CommutationTable'
		/TreeUPID 4530
   		/DefValue 1 % IFFT Calculated			
		/Type 'ENUM'
   		/ENumDef [A  
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											   	   		   		
   		] 	   		   		   	
		]      	   		   		   	  	   
   	[D
   		/Name 'Com_FFT_C1'
   		/TreeUPID 4531
   		/DefValue 1.0 		   	
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_FFT_C3'
   		/TreeUPID 4532
   		/DefValue 0.0 	   		   		   	
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_FFT_C5'
   		/TreeUPID 4533
   		/DefValue 0.0	   		   		   	
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_FFT_C7'
   		/TreeUPID 4534
   		/DefValue 0.0 	   		   		   	
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_FFT_C9'
   		/TreeUPID 4535
   		/DefValue 0.0 	   		   		   	
   		/Type 'DOUBLE'
   	]	   		   										
		[D
   		/Name 'Com_BackEMFTable'
			/TreeUPID 4540
   		/DefValue 1 % IFFT Calculated			
			/Type 'ENUM'
   		/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 2
					%/Caption 'Custom'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'IFFT Calculated'					
					/OnSelect [A ]
				]																											   	   		   		
   		] 	   		   		   	
		]      	   		   		   	  	   
   	[D
   		/Name 'Com_BackEMF_C1'
   		/TreeUPID 4541
   		/DefValue 1.0
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_BackEMF_C3'
   		/TreeUPID 4542
   		/DefValue 0.0
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_BackEMF_C5'
   		/TreeUPID 4543
   		/DefValue 0.0
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_BackEMF_C7'
   		/TreeUPID 4544
   		/DefValue 0.0
   		/Type 'DOUBLE'
   	]	   		   	
   	[D
   		/Name 'Com_BackEMF_C9'
   		/TreeUPID 4545
   		/DefValue 0.0 		   	
   		/Type 'DOUBLE'
   	]	   		   										
% COMMUTATION END

% SLIDER BEGIN   	
	[D
		/Name 'Slider'
		/TreeUPID 6202
   		/DefValue 0
   		/Type 'ENUM'
   		
  	]	
	% SLIDER DIRECTION   	
	[D
   		/Name 'Slider_Direction'
 		/TreeUPID 6211
   		/DefValue 0
   		/Type 'ENUM'
	]		
		
% SLIDER END

% STATOR SUB TYPE
		[D
			/Name 'StatorSubType'
			/TreeUPID 4614
			/Type 'ENUM'
			/DefValue 1
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateMotorProperty']	
				[D	/Name 'CalculateCableResistance']					
				[D  /Name 'CalculateControlParameters']			
			]
			/ENumDef [A
				[D
					/Value 3
					/Caption 'FHA-8C-30-D200-E'					
					/OnSelect [A
						[D /Name 'Motor_Name' /Value 'FHA-8C-30-D200-E']
						[D /Name 'Maximal_Current' /Value 4.24 ]						
						[D /Name 'Maximal_Motor_Supply_Voltage' /Value 48.0]
						[D /Name 'NoOfPolePairs' /Value 5.0]
						[D /Name 'BEMFConstant' /Value 0.001154701]
						[D /Name 'PhasePhase_Resistance' /Value 1.1]
						[D /Name 'PhasePhase_Inductance' /Value 0.00044]  	
						[D /Name 'TempModelPar_RWOutHousing' /Value 5.0]
						[D /Name 'TempModelPar_RHousingMounting' /Value 5.0]
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 10.0]
						[D /Name 'TempModelPar_CWinding' /Value 9.0] 
						[D /Name 'TempModelPar_CHousing' /Value 9.0]
						[D /Name 'TempModelPar_CMounting' /Value 4.5]
						[D /Name 'Warn_Temp' /Value 115.0 ]
						[D /Name 'Error_Temp' /Value 125.0 ]
						[D /Name 'TempModelPar_MaxWindingTemp' /Value 140.0]
						[D /Name 'ExtSensor_CountsPerRev' /Value 8000.0]

						[D /Name 'Motor_Supply_Voltage_Low_Warn' /Value 20.0 ]
						[D /Name 'Motor_Supply_Voltage_Low_Error' /Value 15.0 ]						
						
					]								
					/OnSelectCaseInt [A
						[D
							/CaseVar 'MCTreeID'
							/CaseAnd $FF
							/CaseArr [A
								[D /CaseValue $20 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% E1200
								[D /CaseValue $24 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-0S
								[D /CaseValue $25 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-1S
								[D /CaseValue $26 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-0S
								[D /CaseValue $27 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-1S
								[D /CaseValue $14 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% A1100
							]
						]  
					]
				]
				[D
					/Value 1
					/Caption 'FHA-11C-50-D200-E'					
					/OnSelect [A
					  	[D /Name 'Motor_Name' /Value 'Harmonic Drive FHA-11C-50-D200-E']
					  	[D /Name 'Maximal_Current' /Value 11.5 ]
						[D /Name 'Maximal_Motor_Supply_Voltage' /Value 72.0]
						[D /Name 'NoOfPolePairs' /Value 5.0]
						[D /Name 'BEMFConstant' /Value 0.001041]
						[D /Name 'PhasePhase_Resistance' /Value 0.42]
					   	[D /Name 'PhasePhase_Inductance' /Value 0.0004]	
						[D /Name 'TempModelPar_RWOutHousing' /Value 4.9]
						[D /Name 'TempModelPar_RHousingMounting' /Value 4.9]
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 9.8]
					   	[D /Name 'TempModelPar_CWinding' /Value 16.75] 
						[D /Name 'TempModelPar_CHousing' /Value 16.75]
						[D /Name 'TempModelPar_CMounting' /Value 8.5]
						[D /Name 'Warn_Temp' /Value 100.0 ]
						[D /Name 'Error_Temp' /Value 110.0 ]
						[D /Name 'TempModelPar_MaxWindingTemp' /Value 100.0]
						
						[D /Name 'Motor_Supply_Voltage_Low_Warn' /Value 20.0 ]
						[D /Name 'Motor_Supply_Voltage_Low_Error' /Value 15.0 ]				
					]	
					/OnSelectCaseInt [A
						[D
							/CaseVar 'MCTreeID'
							/CaseAnd $FF
							/CaseArr [A
								[D /CaseValue $20 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% E1200
								[D /CaseValue $24 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-0S
								[D /CaseValue $25 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-1S
								[D /CaseValue $26 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-0S
								[D /CaseValue $27 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-1S
								[D /CaseValue $14 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% A1100
							]
						]  
					]
				]
				[D
					/Value 2
					/Caption 'FHA-11C-100-D200'					
					/OnSelect [A
					  	[D /Name 'Motor_Name' /Value 'Harmonic Drive FHA-11C-100-D200']
					  	[D /Name 'Maximal_Current' /Value 1.1 ]
						[D /Name 'Maximal_Motor_Supply_Voltage' /Value 92.0]
						[D /Name 'NoOfPolePairs' /Value 5.0]
						[D /Name 'BEMFConstant' /Value 0.005658033]
						[D /Name 'PhasePhase_Resistance' /Value 7.4]
					   	[D /Name 'PhasePhase_Inductance' /Value 0.0068]	
						[D /Name 'TempModelPar_RWOutHousing' /Value 6.0]
						[D /Name 'TempModelPar_RHousingMounting' /Value 6.0]
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 12.0]
					   	[D /Name 'TempModelPar_CWinding' /Value 14.0] 
						[D /Name 'TempModelPar_CHousing' /Value 14.0]
						[D /Name 'TempModelPar_CMounting' /Value 7.0]
						[D /Name 'Warn_Temp' /Value 115.0 ]
						[D /Name 'Error_Temp' /Value 125.0 ]
						[D /Name 'TempModelPar_MaxWindingTemp' /Value 140.0]
					]	
					/OnSelectCaseInt [A
						[D
							/CaseVar 'MCTreeID'
							/CaseAnd $FF
							/CaseArr [A
								[D /CaseValue $20 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% E1200
								[D /CaseValue $24 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-0S
								[D /CaseValue $25 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-1S
								[D /CaseValue $26 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-0S
								[D /CaseValue $27 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-1S
								[D /CaseValue $14 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% A1100
							]
						]  
					]
				]																											
				[D
					/Value 3
					/Caption 'FHA-14C-50-D200'					
					/OnSelect [A
					  	[D /Name 'Motor_Name' /Value 'Harmonic Drive FHA-14C-50-D200']
					  	[D /Name 'Maximal_Current' /Value 3.2 ]
						[D /Name 'Maximal_Motor_Supply_Voltage' /Value 92.0]
						[D /Name 'NoOfPolePairs' /Value 5.0]
						[D /Name 'BEMFConstant' /Value 0.006119913]
						[D /Name 'PhasePhase_Resistance' /Value 2.8]
					   	[D /Name 'PhasePhase_Inductance' /Value 0.0036]	
						[D /Name 'TempModelPar_RWOutHousing' /Value 4.0]
						[D /Name 'TempModelPar_RHousingMounting' /Value 4.0]
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 8.0]
					   	[D /Name 'TempModelPar_CWinding' /Value 25.0] 
						[D /Name 'TempModelPar_CHousing' /Value 25.0]
						[D /Name 'TempModelPar_CMounting' /Value 12.5]
						[D /Name 'Warn_Temp' /Value 115.0 ]
						[D /Name 'Error_Temp' /Value 125.0 ]
						[D /Name 'TempModelPar_MaxWindingTemp' /Value 140.0]
					]	
					/OnSelectCaseInt [A
						[D
							/CaseVar 'MCTreeID'
							/CaseAnd $FF
							/CaseArr [A
								[D /CaseValue $20 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% E1200
								[D /CaseValue $24 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-0S
								[D /CaseValue $25 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-1S
								[D /CaseValue $26 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-0S
								[D /CaseValue $27 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-1S
								[D /CaseValue $14 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% A1100
							]
						]  
					]
				]																											
				[D
					/Value 4
					/Caption 'FHA-14C-30-D200-E'					
					/OnSelect [A
						[D /Name 'Motor_Name' /Value 'FHA-14C-30-D200-E']
						[D /Name 'Maximal_Current' /Value 20.0 ]						
						[D /Name 'Maximal_Motor_Supply_Voltage' /Value 48.0]
						[D /Name 'NoOfPolePairs' /Value 5.0]
						[D /Name 'BEMFConstant' /Value 0.001154701]
						[D /Name 'PhasePhase_Resistance' /Value 0.14]
						[D /Name 'PhasePhase_Inductance' /Value 0.00012]  	
						[D /Name 'TempModelPar_RWOutHousing' /Value 2.5]
						[D /Name 'TempModelPar_RHousingMounting' /Value 2.5]
						[D /Name 'TempModelPar_RMountingEnvironment' /Value 5.0]
						[D /Name 'TempModelPar_CWinding' /Value 28.0] 
						[D /Name 'TempModelPar_CHousing' /Value 28.0]
						[D /Name 'TempModelPar_CMounting' /Value 14.0]
						[D /Name 'Warn_Temp' /Value 115.0 ]
						[D /Name 'Error_Temp' /Value 125.0 ]
						[D /Name 'TempModelPar_MaxWindingTemp' /Value 140.0]
						[D /Name 'ExtSensor_CountsPerRev' /Value 8000.0]

						[D /Name 'Motor_Supply_Voltage_Low_Warn' /Value 40.0 ]
						[D /Name 'Motor_Supply_Voltage_Low_Error' /Value 35.0 ]						
						
					]								
					/OnSelectCaseInt [A
						[D
							/CaseVar 'MCTreeID'
							/CaseAnd $FF
							/CaseArr [A
								[D /CaseValue $20 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% E1200
								[D /CaseValue $24 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-0S
								[D /CaseValue $25 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1200-1S
								[D /CaseValue $26 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-0S
								[D /CaseValue $27 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% C1100-1S
								[D /CaseValue $14 /Name 'Com_DeathTimeCompensation' /Value 0.00005 ]% A1100
							]
						]  
					]
				]
			]										
		]	

% END STATOR SUB TYPE


% FLANGE BEGIN
		[D
   			/Name 'Flange'
			/TreeUPID 6203
			/Type 'ENUM'
			/DefValue 0		
		]	
% FLANGE END


% HOMING BEGIN		
		[D
	   		/Name 'Home_Mode'
			/TreeUPID 5060
			/Type 'ENUM'
   			/DefValue 13 % 
   			/StartWithTreeValue #1
			/OnChange [A
%				[D /Name 'CalculateMinMaxPos' ]				
			]
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Actual Position'	
					/DescriptionKeyWord 'HomeMode0_Info'				
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Mechanical Stop Negative Search'					
					/DescriptionKeyWord 'HomeMode1_Info'				
					/OnSelect [A ]
				]																											
				[D
					/Value 2
					%/Caption 'Mechanical Stop Positive Search'					
					/DescriptionKeyWord 'HomeMode2_Info'				
					/OnSelect [A ]
				]																											
				[D
					/Value 14
					%/Caption 'Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode14_Info'				
					/OnSelect [A ]
				]			
				[D
					/Value 15
					%/Caption 'Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode15_Info'				
					/OnSelect [A ]
				]																										
				[D
					/Value 3
					%/Caption 'Home Switch'	
					/DescriptionKeyWord 'HomeMode3_Info'													
					/OnSelect [A ]
				]					
				[D
					/Value 16
					%/Caption 'Home Switch'	
					/DescriptionKeyWord 'HomeMode16_Info'													
					/OnSelect [A ]
				]					
				[D
					/Value 4
					%/Caption 'Home Switch And Mechanical Stop Negative'					
					/DescriptionKeyWord 'HomeMode4_Info'													
					/OnSelect [A ]
				]																											
				[D
					/Value 5
					%/Caption 'Home Switch And Mechanical Stop Positive'					
					/DescriptionKeyWord 'HomeMode5_Info'													
					/OnSelect [A ]
				]				
				[D
					/Value 6
					%/Caption 'Home Switch And Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode6_Info'													
					/OnSelect [A ]
				]																											
				[D
					/Value 7
					%/Caption 'Home Switch And Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode7_Info'													
					/OnSelect [A ]
				]				
				[D
					/Value 8
					%/Caption 'Index On X12 And Mechanical Stop Negative'					
					/DescriptionKeyWord 'HomeMode8_Info'													
					/OnSelect [A ]
				]																											
				[D
					/Value 9
					%/Caption 'Index On X12 And Mechanical Stop Positive'					
					/DescriptionKeyWord 'HomeMode9_Info'													
					/OnSelect [A ]
				]				
				[D
					/Value 10
					%/Caption 'Index On X12 And Limit Switch Negative'					
					/DescriptionKeyWord 'HomeMode10_Info'													
					/OnSelect [A ]
				]																											
				[D
					/Value 11
					%/Caption 'Index On X12 And Limit Switch Positive'					
					/DescriptionKeyWord 'HomeMode11_Info'													
					/OnSelect [A ]
				]					
				[D
					/Value 12
					%/Caption 'Index On X12 Negative Search'					
					/DescriptionKeyWord 'HomeMode12_Info'													
					/OnSelect [A ]
				]																											
				[D
					/Value 13
					%/Caption 'Index On X12 Positive Search'					
					/DescriptionKeyWord 'HomeMode13_Info'													
					/OnSelect [A ]
				]																																							
				[D
					/Value 17
					%/Caption 'No Drive Homing'					
					/DescriptionKeyWord 'HomeMode17_Info'													
					/Hide #0
					/OnSelect [A ]
				]																																							
			]	
		]      	   		   		   	  	  
		[D
			/Name 'HomeConf_CurrentLimit'
			/TreeUPID 5061
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_FollowingErrorLimit'
			/TreeUPID 5062
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'HomeConf_HomePosition'
			/TreeUPID 5063
   			/StartWithTreeValue #1
			/DefValue 0.0
			/Type 'DOUBLE'
			/OnChange [A 
%				[D /Name 'CalculateMinMaxPos' ]				
			]
		]      	   		   		   	  	   
		[D
   		/Name 'HomeConf_MaxSpeed'
			/TreeUPID 5064
			/DefValue 0.01
   			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
   		/Name 'HomeConf_Acceleration'
			/TreeUPID 5065
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
   		/Name 'HomeConf_SliderHomePosition'
			/TreeUPID 5066
   			/StartWithTreeValue #1
			/Type 'DOUBLE'
			/OnChange [A 
%				[D /Name 'CalculateMinMaxPos' ]				
			]
		]      	   		 
% HOMING BEGIN		

% CHECK POS CONFIG BEGIN
		[D
			/Name 'CheckPos_AutoOnHoming'
			/TreeUPID 5070
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A ]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A ]
				]																											
			]	
		]      	   		 
		[D
			/Name 'CheckPos_Position1'
			/TreeUPID 5071
			/Type 'DOUBLE'
		]      	   		 
		[D
			/Name 'CheckPos_Position2'
			/TreeUPID 5072
			/Type 'DOUBLE'
		]      	   		 
		[D
			/Name 'CheckPos_MaxSpeed'
			/TreeUPID 5073
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
   		/Name 'CheckPos_Acceleration'
			/TreeUPID 5074
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
   		/Name 'CheckPos_Decceleration'
			/TreeUPID 5075
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		  		 
% CHECK POS CONFIG END

% INITIAL POS CONFIG BEGIN
		[D
   			/Name 'InitialPosConf_AutoOnHoming'
			/TreeUPID 5080
			/Type 'ENUM'
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Disable'					
					/OnSelect [A	
					]
				]																											
				[D
					/Value 1
					%/Caption 'Enable'					
					/OnSelect [A	
					]
				]																											
			]							
		]      	   		 
		[D
			/Name 'InitialPosConf_Position'
			/TreeUPID 5081
			/Type 'DOUBLE'
			/StartWithTreeValue #1
 			/OnChange [A 
	%			[D /Name 'CalculateMinMaxPos' ]				
			]
   		   		
		]      	   		   		   	  	   
		[D
			/Name 'InitialPosConf_MaxSpeed'
			/TreeUPID 5082
			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'InitialPosConf_Acceleration'
			/TreeUPID 5083
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 
		[D
			/Name 'InitialPosConf_Decceleration'
			/TreeUPID 5084
			/Type 'DOUBLE'
		]      	   		   		   	  	   								 		  		 		  				  		   	  	   
% INITIAL POS CONFIG END

% POSITION MONITORING BEGIN
		[D
			/Name 'Minimal_Position'
			/TreeUPID 5230
			/StartWithTreeValue #1
			/CaptionKeyWord 'Min_Pos_Stroke_Range'
			/Type 'DOUBLE'
			/OnChange [A	[D	/Name 'CalculateStrokeRange'	]	]
		]      	   		   		   	  	   								 
		[D
			/Name 'Maximal_Position'
			/TreeUPID 5231
			/StartWithTreeValue #1
			/CaptionKeyWord 'Max_Pos_Stroke_Range'
			/Type 'DOUBLE'
			/OnChange [A	[D	/Name 'CalculateStrokeRange'	]	]
		]      	   		   		   	  	   								 
% POSITION MONITORING END


% FF SETUP BEGIN
		[D
   			/Name 'Move_Part'
			/TreeUPID 6204
			/Type 'ENUM'
	   	]
		[D
	   		/Name 'Additional_Mass'
			/TreeUPID 6205
   			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'Orientation'
			/TreeUPID 6206
   			/Type 'DOUBLE'
		]      	   		   		   	  	   
		[D
			/Name 'Dry_Friction'
			/TreeUPID 6207
   			/Type 'DOUBLE'
		]   
		[D
			/Name 'Viscous_Friction'
			/TreeUPID 6236
   			/Type 'DOUBLE'
		]   		   	   		   		   	  	   
		[D
			/Name 'Constant_Force'
			/TreeUPID 6237
			/Type 'DOUBLE'
		]   
   		[D	
   			/Name 'Force_Direction'
			/TreeUPID 6238
			/Type 'ENUM'
		]		
		
		   	   		   		   	  	   				
% FF SETUP END

% CONTROL PARAMETER BEGIN
		[D
   			/Name 'ControlParameter_SetSelection'
			/TreeUPID 5011
			/Type 'ENUM'
   			/DefValue 0
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Control Parameter Set A'					
					/OnSelect [A	]
				]																											
				[D
					/Value 1
					%/Caption 'Control Parameter Set B'					
					/OnSelect [A	]
				]																											
			]	
		]      	   		   		   	  	   
		% CONTROL PARAMETER SET A
		[D
			/Name 'FF_ConstForce_SetA'
			/TreeUPID 5020
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Friction_SetA'
			/TreeUPID 5021
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Spring_SetA'
			/TreeUPID 5022
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Damping_SetA'
			/TreeUPID 5023
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'FF_Acceleration_SetA'
			/TreeUPID 5024
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		 
		[D
			/Name 'Spring_ZP_SetA'
			/TreeUPID 5025
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'P_Gain_SetA'
			/TreeUPID 5026
	   		/StartWithTreeValue #1
  			/DefValue 10000.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'D_Gain_SetA'
			/TreeUPID 5027
   			/StartWithTreeValue #1
			/DefValue 15.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'I_Gain_SetA'
			/TreeUPID 5028
			%/Caption 'I Gain'
   			/StartWithTreeValue #1
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'D_FilterTime_SetA'
			/TreeUPID 5032
			/StartWithTreeValue #1
			/DefValue 0.0
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'IntegratorLimit_SetA'
			/TreeUPID 5029
			/Type 'DOUBLE'
		]      	   		   		   	  	      
		[D
			/Name 'MaxCurrent_SetA'
			/TreeUPID 5030
			/Type 'DOUBLE'
		]      	   		
   		[D
   			/Name 'NoiseDeadBandSetA'
			/TreeUPID 5031
			/Type 'DOUBLE'
			/CaptionKeyWord 'NoiseFilterDeadband'
			/DefValue 0.0
		]      	   		   		   	  	      

		   		   	  	      

% WARNING MASK BEGIN
		[D
			/Name 'WarnMask_MotorTempSensor'
			/TreeUPID 5580
			/DefValue #0
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorHotCalculated'
			/TreeUPID 5581
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorVoltageLow'
			/TreeUPID 5582
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorVoltageHigh'
			/TreeUPID 5583
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_FollowingWarnMoving'
			/TreeUPID 5584
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_FollowingWarnStanding'
			/TreeUPID 5585
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MCBoardTemperature'
			/TreeUPID 5586
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_MotorNotHomed'
			/TreeUPID 5587
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_PTCTempSens1'
			/TreeUPID 5588
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_PTCTempSens2'
			/TreeUPID 5589
			/Type 'BOOLEAN'
		] 
		
		[D
			/Name 'WarnMask_BleederHotCalculated'
			/TreeUPID 5590
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_InterfaceSWWarnFlag'
			/TreeUPID 5594
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'WarnMask_ApplicationSWWarnFlag'
			/TreeUPID 5595
			/Type 'BOOLEAN'
		] 
% WARNING MASK END

% ERROR MASK BEGIN
		[D
			/Name 'ErrMask_LogicVoltageLow'
			/TreeUPID 5500
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_LogicVoltageHigh'
			/TreeUPID 5501
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorVoltageLow'
			/TreeUPID 5502
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorVoltageHigh'
			/TreeUPID 5503
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_ShortTimeOverload'
			/TreeUPID 5504
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorTempSensor'
			/TreeUPID 5505
			/Type 'BOOLEAN'
			/DefValue #0
		] 
		[D
			/Name 'ErrMask_PTCTempSensor'
			/TreeUPID 5506
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MCBoardTemperature'
			/TreeUPID 5507
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MotorSliderMissing'
			/TreeUPID 5508
			/Type 'BOOLEAN'
			/DefValue #0
		] 
		[D
			/Name 'ErrMask_MotorHallSignalMissing'
			/TreeUPID 5509
			/Type 'BOOLEAN'
			/DefValue #0
		] 
		[D
			/Name 'ErrMask_ExtPosSensor'
			/TreeUPID 5510
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_FollowingWarnMoving'
			/TreeUPID 5511
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_FollowingWarnStanding'
			/TreeUPID 5512
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_PhaseGNDPathError'
			/TreeUPID 5513
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_PhasePWRVolPathError'
			/TreeUPID 5514
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_OverCurrent'
			/TreeUPID 5515
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MinimalPosition'
			/TreeUPID 5516
			/StartWithTreeValue #1
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_MaximalPosition'
			/TreeUPID 5517
			/StartWithTreeValue #1
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_BleederCheck'
			/TreeUPID 5518
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_BleederTempCalculated'
			/TreeUPID 5519
			/Type 'BOOLEAN'
		] 
		[D
			/Name 'ErrMask_CheckStatorType'
			/TreeUPID 5520
			/Type 'BOOLEAN'
		] 
% ERROR MASK END


% TEMPERATURE MONITORING BEGIN
		[D
			/Name 'TempSens_WarnTime'
			/TreeUPID 4601
			/Type 'DOUBLE'
		] 
		[D
			/Name 'TempSens_ErrorTime'
			/TreeUPID 4602
			/Type 'DOUBLE'
		] 
		[D
			/Name 'Communication_Type'
			/TreeUPID 4603
			/Type 'ENUM'
			/DefValue 0			
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'None'					
					/OnSelect [A ]
				]																											   	   		   		
				[D
					/Value 1
					%/Caption 'P01'					
					/OnSelect [A ]
				]																											   	   		   		
			] 	   		   		   							
		] 
		[D
   			/Name 'NrOfMotTemp_Values'
			/TreeUPID 4604
			/Type 'DOUBLE'
		] 
		  		[D
  			/Name 'TakeCorrectionValueMask_SineOffset'
			/TreeUPID 4670
			/Type 'BOOLEAN'
 			/DefValue #0
		] 
  		[D
  			/Name 'TakeCorrectionValueMask_CosineOffset'
			/TreeUPID 4671
			/Type 'BOOLEAN'
			/DefValue #0
		] 
  		[D	
  			/Name 'TakeCorrectionValueMask_CosSinRelGain'
			/TreeUPID 4672
			/Type 'BOOLEAN'
			/DefValue #0
		]
		[D 
  			/Name 'TakeCorrectionValueMask_SensorDistError'
			/TreeUPID 4673
			/Type 'BOOLEAN'
			/DefValue #0
		] 				
		[D 
			/Name 'TakeCorrectionValueMask_CommutationAngle'
			/TreeUPID 4675
			/Type 'BOOLEAN'
			/DefValue #0
		] 				
		[D
			/Name 'PhaseResistence_TempCorrection'
			/TreeUPID 4615
			/Type 'ENUM'
			/DefValue 1
			/ENumDef [A
				[D
					/Value 0
					%/Caption 'Off'					
					/OnSelect [A	]
				]																											
				[D
					/Value 1
					%/Caption 'Temperature Calculated'					
					/OnSelect [A	]
				]																											
				[D
					/Value 2
					%/Caption 'Temperature Read Out'
					/OnSelect [A 	]
				]																											
			]	
		] 
		[D
	   		/Name 'TempModelPar_CWinding'
			/TreeUPID 4620
			/Type 'DOUBLE'
		] 
		[D
  	 		/Name 'TempModelPar_RWindingWinding'
			/TreeUPID 4621
			/DefValue 0.01
			/Type 'DOUBLE'
		] 
		[D
	   		/Name 'TempModelPar_RWindingWOut'
			/TreeUPID 4622
			/DefValue 0.01
			/Type 'DOUBLE'
		] 
		[D
   			/Name 'TempModelPar_CWOut'
			/TreeUPID 4623
			/DefValue 0.25
			/Type 'DOUBLE'
		] 
		[D
	   		/Name 'TempModelPar_RWOutHousing'
			/TreeUPID 4624
			/Type 'DOUBLE'
		] 
		[D
   			/Name 'TempModelPar_CHousing'
			/TreeUPID 4625
			/Type 'DOUBLE'
		] 
		[D
   			/Name 'TempModelPar_RHousingMounting'
			/TreeUPID 4626
			/Type 'DOUBLE'
		] 
		[D
   			/Name 'TempModelPar_CMounting'
			/TreeUPID 4627
			/Type 'DOUBLE'
		] 
		[D
   			/Name 'TempModelPar_RMountingEnvironment'
			/TreeUPID 4628
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'TempModelPar_EnvironmentTemp'
			/TreeUPID 4629
			/Type 'DOUBLE'
 			/DefValue 25.0 
		] 
   		[D
   		/Name 'TempModelPar_MaxWindingTemp'
			/TreeUPID 4612
			/Type 'DOUBLE'
		] 

% NEW I^2t TEMPERATURE MODEL

		[D
   		/Name 'C_Winding'
			/TreeUPID 4650
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'R_WindingOutside'
			/TreeUPID 4651
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'Temp_WindingOutside'
			/TreeUPID 4653
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'Warn_Temp'
			/TreeUPID 4610
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'Error_Temp'
			/TreeUPID 4611
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'Warn_Temp_Off'
			/TreeUPID 4682
			/Type 'DOUBLE'
		] 
		[D
   		/Name 'Error_Temp_Off'
			/TreeUPID 4683
			/Type 'DOUBLE'
		] 				

% TEMPERATURE MONITORING END
		
% Phase Search Begin
		[D
   		/Name 'PhaseSearch_MaxPos'
			/TreeUPID 5975
			/Type 'DOUBLE'
		]
		[D 
   		/Name 'PhaseSearch_MaxSpeed'
			/TreeUPID 5976
			/Type 'DOUBLE'
		] 

% Phase Search End;		
		
		
		
		
		
		% EXTENSION CABLE BEGIN		
		[D
			/Name 'Ext_Cable_Resistance'
			/CaptionKeyWord 'Ext_Cable_Resistance'
			/TreeUPID 4518
			/DefValue 0.0
			/StartWithTreeValue #1
			/Type 'DOUBLE'		
		]		
		% CABLE1 BEGIN
		[D
			/Name 'Cable1_Type'
			/TreeUPID 6230
			/DefValue 0
			/StartWithTreeValue #1   
			/Type 'ENUM'
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Cable'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.0 ] 
					]
				]																											
				[D
					/Value 2
					/Caption 'K05'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 3
					/Caption 'K15'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.012 ] 
					]
				]																											
				[D
					/Value 4
					/Caption 'KS05'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 5
					/Caption 'KS10'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Generic_Cable'
					/OnSelect [A
					]					
				]																											
			]				
		]	

		[D
			/Name 'Cable1_Section'
			/TreeUPID 6231

			/DefValue 1
			/StartWithTreeValue #1
			/Type 'ENUM'								
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption '0.34 mm^2 / AWG 22'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 1
					/Caption '0.5 mm^2 / AWG 20'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 2
					/Caption '0.75 mm^2 / AWG 19'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.024 ] 
					]
				]																											
				[D
					/Value 3
					/Caption '1.0 mm^2 / AWG 18'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 4
					/Caption '1.5 mm^2 / AWG 16'					
					/OnSelect [A 
						[D /Name 'Cable1_Resistivity_Gen' /Value 0.012 ] 
					]
				]																											
			]	
		]	

		[D
			/Name 'Cable1_Length'
			/TreeUPID 6232
			/DefValue 0.0
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/Type 'DOUBLE'								
		]



		[D
			/Name 'Cable2_Type'
			/TreeUPID 6233
			/DefValue 0
			/StartWithTreeValue #1   		
			/Type 'ENUM'
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/CaptionKeyWord 'No_Cable'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.0 ] 
					]
				]																											
				[D
					/Value 2
					/Caption 'K05'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 3
					/Caption 'K15'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.012 ] 
					]
				]																											
				[D
					/Value 4
					/Caption 'KS05'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 5
					/Caption 'KS10'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 1
					/CaptionKeyWord 'Generic_Cable'					
					/OnSelect [A 
						%[D /Name 'Cable2_Section' /Value 0 ]
					]  
				]																											
			]				
		]	
		[D
			/Name 'Cable2_Section'
			/TreeUPID 6234
			/DefValue 0
			/StartWithTreeValue #1
			/Type 'ENUM'								
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/ENumDef [A
				[D
					/Value 0
					/Caption '0.34 mm^2 / AWG 22'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.053 ] 
					]
				]																											
				[D
					/Value 1
					/Caption '0.5 mm^2 / AWG 20'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.036 ] 
					]
				]																											
				[D
					/Value 2
					/Caption '0.75 mm^2 / AWG 19'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.024 ] 
					]
				]																											
				[D
					/Value 3
					/Caption '1.0 mm^2 / AWG 18'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.018 ] 
					]
				]																											
				[D
					/Value 4
					/Caption '1.5 mm^2 / AWG 16'					
					/OnSelect [A 
						[D /Name 'Cable2_Resistivity_Gen' /Value 0.012 ] 
					]
				]																											
			]	
		]	
		[D
			/Name 'Cable2_Length'
			/TreeUPID 6235
			/DefValue 0.0
			/StartWithTreeValue #1
			/OnChange [A
				[D	/Name 'CalculateCableResistance']				
			]
			/Type 'DOUBLE'								

		]		
		% CABLE2 END
		[D
			/Name 'PosRec_Mode'
			/TreeUPID 5088
			/Type 'ENUM'
			/OnChange [A
			]   	
			/DefValue 0 
			/StartWithTreeValue #1
			/ENumDef [A
				[D
					/Value 0
					/OnSelect [A
					]
				]																											
			]	
		]     
		[D 
			/Name 'Unit_Display_Mode'
			/TreeUPID 2048 
			/Type 'ENUM'
			/DefValue 2 
			/StartWithTreeValue #1 /OnChange [A 
			] 
			/ENumDef [A 
				%[D 
				%	/Value 1 
				%	/DescriptionKeyWord 'SI (linear)'
				%	/OnSelect [A 
				%	] 
				%] 
				[D
					/Value 2
					/DescriptionKeyWord 'Metric (linear)'
					/OnSelect [A
					]
				]
				%[D
				%	/Value 3
				%	/DescriptionKeyWord 'Imperial (linear)'
				%	/OnSelect [A
				%	]
				%]						
				[D
					/Value 4
					/DescriptionKeyWord 'Degree (rotative)'
					/OnSelect [A
					]
				]
				%[D
				%	/Value 5
				%	/DescriptionKeyWord 'U/min (rotative)'
				%	/OnSelect [A
				%	]
				%]
			] 
		]
		[D 
			/Name 'Unit_Factor_m1_low'
			/TreeUPID 2049 
			/Type 'ENUM'
			/DefValue 0 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_0_low'
			/TreeUPID 2050 
			/Type 'ENUM'
			/DefValue 0 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_1_low'
			/TreeUPID 2051 
			/Type 'ENUM'
			/DefValue 0 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_2_low'
			/TreeUPID 2052 
			/Type 'ENUM'
			/DefValue 0 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_m1_high'
			/TreeUPID 2053 
			/Type 'ENUM'
			/DefValue 1072693248 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_0_high'
			/TreeUPID 2054 
			/Type 'ENUM'
			/DefValue 1072693248 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_1_high'
			/TreeUPID 2055 
			/Type 'ENUM'
			/DefValue 1072693248 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Unit_Factor_2_high'
			/TreeUPID 2056 
			/Type 'ENUM'
			/DefValue 1072693248 
			/StartWithTreeValue #1 ] 
		[D 
			/Name 'Wizard_Executed'
			/DefValue 1.0 
			/TreeUPID 6253 
			/Type 'DOUBLE' 
		]
		[D 
			/Name 'GearLoadFactor'
			/TreeUPID $0809 
			/Type 'DOUBLE'
			/DefValue 1.0 
			/StartWithTreeValue #1 /DebugSource 'EC02-XxX_SRC.adp'
		] 
		[D 
			/Name 'GearMotorFactor'
			/TreeUPID $080A 
			/Type 'DOUBLE'
			/DefValue 1.0 
			/StartWithTreeValue #1 /DebugSource 'EC02-XxX_SRC.adp'
		] 
		[D 
			/Name 'GearPIDonLoadSide'
			/TreeUPID $080B 
			/Type 'BOOLEAN'
			/DefValue #1 /StartWithTreeValue #1 /DebugSource 'EC02-XxX_SRC.adp'
		] 		
		] 				

	]
]   